--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Brick_Matrix_Package
--------------------------------------------------------------------------------

with Ada.Text_Io,Ada.Directories,Ada.Strings.Unbounded,Ada.Exceptions,Text_Io.Unbounded_IO,win32.GL,Ada.Numerics.Float_Random,Ada.Numerics.Discrete_Random,Runtime_Log;
use Ada.Text_Io,Ada.Directories,Ada.Strings.Unbounded,Ada.Exceptions,win32.GL,Ada.Numerics,Runtime_Log;

package body Brick_Matrix_Package is
    package Brick_Random is new Discrete_Random(Firm_Brick_Placing);
    package Points_Random is new Discrete_Random(Brick_Points);
    Points_Gen : Points_Random.Generator;
    Firm_Brick_Gen : Brick_Random.Generator;
    Float_Gen : Float_Random.Generator;




    procedure Generate_New_Brick_Matrix
      (Result: out Brick_Matrix;
       Pattern : in Brick_Place_availability)
    is
    begin
        Points_Random.Reset(Points_Gen);
        Brick_Random.Reset(Firm_Brick_Gen);
        Float_Random.Reset(Float_Gen);

        for I in 1..Rozmiar_Planszy
        loop
            for J in 1..Rozmiar_Planszy
            loop
                if Pattern(I,J)=Place_Any_Kind
                then
                    Generate_New_Brick(klocek => result(I,J),
                                       Wzor   => Brick_Random.Random(Firm_Brick_Gen));
                else
                    Generate_New_Brick(klocek => result(I,J),
                                       Wzor   => Pattern(I,J));
                end if;

            end loop;
        end loop;
        Log.Info("Wygenerowano Plansze losowych klockow");
    end Generate_New_Brick_Matrix;


    procedure Generate_New_Brick(Klocek : out Brick; Wzor : in Firm_Brick_Placing) is
    begin
        case Wzor is
            when Place_None =>  Klocek.Exists:=False;
            when Place_Indestructible =>
                Klocek.Exists:=True;
                Klocek.How_Many_Points:=0;
                Klocek.Destroyable:=False;
                --Klocek.Probability_Of_Explosion:=0.0;
                --Klocek.Probability_Of_Bonus:=0.0;
                Klocek.Color:=(R=>0.1,G=>0.4,B=>0.6);
            when Place_Only_Destroyable =>
                Klocek.Exists:=True;
                Klocek.How_Many_Points:=Points_Random.Random(Points_Gen);
                Klocek.Destroyable:=True;
                --Klocek.Probability_Of_Explosion:=Float_Random.Random(Float_Gen)/8.0;
                --Klocek.Probability_Of_Bonus:=Float_Random.Random(Float_Gen)/5.0;
                Klocek.Color:=(
                               R=>GlFloat(Float_Random.Random(Float_Gen)/2.0+0.25 ),
                               G=>GlFloat(Float_Random.Random(Float_Gen)/1.5)+0.25 ,
                               B=>GlFloat(Float_Random.Random(Float_Gen)/1.5)+0.25);
        end case;
    end;

    procedure LoadPatternFromFile(Tablica :out Brick_Place_Availability; Sciezka : in String) is
        Plik : File_Type;
        Tekst : Unbounded_String;
        ch : Character;
    begin
        if Exists(Sciezka) then
            Ada.Text_IO.Open(Plik,In_File,Sciezka);
            for I in 1..Rozmiar_Planszy
            loop
                Tekst:=Ada.Text_IO.Unbounded_IO.Get_Line(Plik);
                --Ada.Text_IO.Unbounded_IO.Put_Line(Tekst);
                for J in 1..Rozmiar_Planszy
                loop
                    Ch:=Element(Tekst,J);
                    case ch is
                    when 'X' => Tablica(I,J):=Place_Indestructible;
                    when ' ' => Tablica(I,J):=Place_None;
                    when 'D' => Tablica(I,J):=Place_Only_Destroyable;
                    when 'A' => Tablica(I,J):=Place_Any_Kind;
                    when others => Put_Line("Plik Uszkodzony");raise Program_Error;
                    end case;
                end loop;
            end loop;
            Ada.Text_IO.Close(Plik);
        else
            Log.Warning("Wybrany plik:""" &Sciezka& """ nie isnieje" );
        end if;
    exception
        when Event: others =>
            Log.Error("Nastapil wyjatek w module symulacji fizyki, nazwa: "& Exception_Name(Event)&" jego opis: "& Exception_Message(Event));
    end;
end brick_matrix_package;
