--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Brick_Matrix_Package
-- Krtki opis:		Pakiet zawierajacy opis typu przechowujacego tablice klockow
--					rozmiar jest definiowany globalnie, zawiera tez funkcje do
--					obslugi tyche macierzy (wczytywanie, generowanie).
--------------------------------------------------------------------------------


with Common_Data; use Common_Data;

package Brick_Matrix_Package is

    type Brick_Matrix is array (1..Rozmiar_Planszy,1..Rozmiar_Planszy) of Brick;
    type Brick_Placing is (Place_None, Place_Indestructible, Place_Only_Destroyable, Place_Any_Kind);
    subtype Firm_Brick_Placing is Brick_Placing range Place_None..Place_Only_Destroyable;
    type Brick_Place_Availability is array (1..Rozmiar_Planszy,1..Rozmiar_Planszy) of Brick_Placing;

    procedure Generate_New_Brick_Matrix(Result : out Brick_Matrix;Pattern : in Brick_Place_availability);

    Procedure Generate_New_Brick(klocek : out Brick; wzor : in Firm_Brick_Placing);

    procedure LoadPatternFromFile(Tablica :out Brick_Place_Availability; Sciezka : in String);

end brick_matrix_package;