--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Game_State_Package
-- Krtki opis:		Pakiet przechowujacy w 3 obiektach chronionych stan programu:
--					Biezaca konfiguracje widoku, planszy oraz informacje o graczach
--					Dane sa niezaleznie modyfikowane i wyswietlane, dlatego trzeba zadbac o dostep do nich
--------------------------------------------------------------------------------

with Ada.Numerics.Discrete_Random;
use  Ada.Numerics;
package body Game_State_Package is
    package Bool_Random is new Discrete_Random(Boolean);
    BoolGen : Bool_Random.Generator;
    ----------------
    -- Game_State --
    ----------------

    protected body Board_State is
        function Get_Info
          return String is
        begin
            return To_String(Info);
        end;

        function Started
          return Ada.Calendar.Time is
        begin
            return Game_Started;
        end;


        procedure Set_Info(Inf : in String) is
        begin
            Info:=To_Unbounded_String(Inf);
        end;
        function Get_Brick_Matrix_State
          return Brick_Matrix
        is
        begin
            return Brick_Matrix_State;
        end;

        function Get_Pad1
          return Pad_Type
        is
        begin
            return PAd1;
        end;

        function Get_Pad2
          return Pad_Type
        is
        begin
            return Pad2;
        end;

        function Get_Ball
          return Ball_Type
        is
        begin
            return Ball;
        end;


        function Brick_Exists(X : in Integer;Y : in Integer)
                            return Boolean is
        begin
            if X<1 or else Y<1 or else X>Rozmiar_Planszy or else Y>Rozmiar_Planszy then
                return False;
            else
                return Brick_Matrix_State(Y,X).Exists;
            end if;
        end;

        function Enabled
          return Boolean is
        begin
            return Going;
        end;

        procedure Set_Brick(Where_X,Where_Y :  in Integer;What : in Common_Data.Brick) is
        begin
            Brick_Matrix_State(Where_Y,Where_X):=What;
        end;

        procedure Pad1_Go(X : Direction) is
        begin
            if X=L then

                if Pad1.Position.X > Pad1.Width/2.0+Pad_Step+1.0 then
                    Pad1.Position.X:=Pad1.Position.X-Pad_Step;
                elsif Pad1.Position.X > Pad1.Width/2.0+1.0 then
                    PAd1.Position.X:=Pad1.Width/2.0+1.0;
                end if;
            elsif X=R then
                if Pad1.Position.X < Glfloat(Rozmiar_Planszy)-(Pad1.Width/2.0+Pad_Step)-1.0 then
                    Pad1.Position.X:=Pad1.Position.X+Pad_Step;
                elsif Pad1.Position.X < Glfloat(Rozmiar_Planszy)-Pad1.Width/2.0-1.0 then
                    PAd1.Position.X:=Glfloat(Rozmiar_Planszy)-Pad1.Width/2.0-1.0;
                end if;
            end if;
        end;

        procedure Pad2_Go(X : Direction) is
        begin
            if X=L then

                if Pad2.Position.X > Pad2.Width/2.0+Pad_Step+1.0 then
                    Pad2.Position.X:=Pad2.Position.X-Pad_Step;
                elsif Pad2.Position.X > Pad2.Width/2.0+1.0 then
                    PAd2.Position.X:=Pad2.Width/2.0+1.0;
                end if;
            elsif X=R then
                if Pad2.Position.X < Glfloat(Rozmiar_Planszy)-(Pad2.Width/2.0+Pad_Step)-1.0 then
                    Pad2.Position.X:=Pad2.Position.X+Pad_Step;
                elsif Pad2.Position.X < Glfloat(Rozmiar_Planszy)-Pad2.Width/2.0-1.0 then
                    PAd2.Position.X:=Glfloat(Rozmiar_Planszy)-Pad2.Width/2.0-1.0;
                end if;
            end if;
        end;

        procedure Ball_Step is
        begin
            BAll.Pos.X:=BAll.Pos.X+GLfloat(Common_Data.Physics_Clock)*Ball.Velocity.X;
            BAll.Pos.Y:=BAll.Pos.Y+GLfloat(Common_Data.Physics_Clock)*Ball.Velocity.Y;
        end Ball_Step;
        procedure Ball_Change(nowa : in Ball_Type) is
        begin
            Ball:=nowa;
        end;


        procedure Ball_Bounce(Where: in Dir_Change) is
        begin

            if Where(L) then Ball.Velocity.X:=-abs(Ball.Velocity.X); end if;
            if Where(R) then Ball.Velocity.X:=abs(Ball.Velocity.X);end if;
            if Where(U) then Ball.Velocity.Y:=abs(Ball.Velocity.Y);end if;
            if Where(D) then Ball.Velocity.Y:=-abs(Ball.Velocity.Y);end if;
            if Where(LD) then
                Ball.Velocity.X:=-Ball.Velocity.Y;
                Ball.Velocity.Y:=-Ball.Velocity.X;
            end if;
            if Where(RD) then
                Ball.Velocity.X:=Ball.Velocity.Y;
                Ball.Velocity.Y:=Ball.Velocity.X;
            end if;
            if Where(LU) then
                Ball.Velocity.X:=Ball.Velocity.Y;
                Ball.Velocity.Y:=Ball.Velocity.X;
            end if;
            if Where(RU) then
                Ball.Velocity.X:=-Ball.Velocity.Y;
                Ball.Velocity.Y:=-Ball.Velocity.X;
            end if;

        end;
        procedure Reset_Ball is
        begin
            Ball.Pos:=Common_Data.Initial_Ball_Pos;
            Ball.Velocity:=Common_Data.Initial_Ball_Vel;
            if Bool_Random.Random(BoolGen) then
                Ball.Velocity.Y:=-Ball.Velocity.Y;
            end if;

            Ball.Owner:=none;
        end;



        procedure Reset is
            Wzor : Brick_Place_Availability;
        begin
            Set_Info("");
            Brick_Matrix_Package.LoadPatternFromFile(Tablica => Wzor,
                                                     Sciezka => "boards/"&Board_Pattern);
            Brick_Matrix_Package.Generate_New_Brick_Matrix(Result  => Brick_Matrix_State,
                                                           Pattern => Wzor);
            PAd1.Color:=(0.6,0.2,0.2);
            Pad1.Width:=0.3*Glfloat(Common_Data.Rozmiar_Planszy);
            PAd1.Position.X:=0.5*Glfloat(Common_Data.Rozmiar_Planszy);
            PAd1.Position.Y:=-0.5;



            PAd2.Color:=(0.2,0.6,0.2);
            Pad2.Width:=0.3*Glfloat(Common_Data.Rozmiar_Planszy);
            PAd2.Position.X:=0.5*Glfloat(Common_Data.Rozmiar_Planszy);
            PAd2.Position.Y:=Glfloat(Common_Data.Rozmiar_Planszy)+0.5;

            Ball.Color:=(1.0,1.0,0.0);
            Reset_Ball;
            Going:=True;
            Game_Started:=Ada.Calendar.Clock;
        end;
        procedure Stop is
        begin
            Going :=False;
        end;
        procedure Start is
        begin
            Going :=True;
        end;

    end Board_State;

    protected body View_State is

        function Get
          return User_View_Type
        is
        begin
            return User_View;
        end Get;


        procedure Angle_Change(Delta_H:in GLfloat ; Delta_V : in GLfloat) is
        begin
            User_View.Horizontal_Angle:=User_View.Horizontal_Angle+Delta_H;
            User_View.Vertical_Angle:=User_View.Vertical_Angle+Delta_V;
        end;

        procedure Distance_Change(Delta_D : in GLdouble) is
        begin
            User_View.Distance:=User_View.Distance+Delta_D;
        end;

    end View_State;

    protected body Players_State is
        function Get1
          return Key_Preset is
        begin
            return Player1_Keys;
        end;

        function Get2
          return Key_Preset is
        begin
            return Player2_Keys;
        end;

        procedure Set1(Nowy : in Key_Preset) is
        begin
            Player1_Keys:=Nowy;
        end;

        procedure Set2(Nowy : in Key_Preset) is
        begin
            Player2_Keys:=Nowy;
        end;

        procedure Add1(Ile : in Integer) is
        begin
            Player1_Points:=Player1_Points+Ile;
        end;
        procedure Add2(Ile : in Integer) is
        begin
            Player2_Points:=Player2_Points+Ile;
        end;

        function R1
          return Integer is
        begin
            return Player1_Points;
        end R1;

        function R2
          return Integer is
        begin
            return Player2_Points;
        end R2;


        procedure Reset_Players is
        begin
            Player1_Points:=Initial_Points;
            Player2_Points:=Initial_Points;
        end;


    end Players_State;
begin
    Bool_Random.Reset(BoolGen);

end Game_State_Package;
