--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Game_State_Package
-- Krtki opis:		Pakiet przechowujacy w 3 obiektach chronionych stan programu:
--					Biezaca konfiguracje widoku, planszy oraz informacje o graczach
--					Dane sa niezaleznie modyfikowane i wyswietlane, dlatego trzeba zadbac o dostep do nich
--------------------------------------------------------------------------------

with Brick_Matrix_Package,Win32.GL,Common_Data,Ada.Strings.Unbounded,Ada.Calendar;
use Brick_Matrix_Package,Win32.GL,Common_Data,Ada.Strings.Unbounded,Ada.Calendar;


package Game_State_Package is
    type User_View_Type is
        record
            Horizontal_Angle : GLfloat;
            Vertical_Angle : GLfloat;
            Distance : GLdouble;
        end record;
    protected Board_State is

        function Get_Info
          return String;
        procedure Set_Info(inf : in String);
        function Get_Brick_Matrix_State
          return Brick_Matrix;
        function Get_Pad1
          return Pad_Type;
        function Get_Pad2
          return Pad_Type;
        function Get_Ball
          return Ball_Type;
        function Brick_Exists(X : in Integer;Y : in Integer)
                            return Boolean;
        function Enabled
          return Boolean;
        function Started
          return Ada.Calendar.Time;

        procedure Reset;
        procedure Reset_Ball;
		
        procedure Pad1_Go(x : Direction);
        procedure Pad2_Go(X : Direction);

        procedure Ball_Step;
        procedure Ball_Bounce(Where: in Dir_Change);
        procedure Ball_Change(nowa : in Ball_Type);

        procedure Set_Brick(Where_X,Where_Y :  in Integer;What : in Common_Data.Brick);
        procedure Start;
        procedure Stop;
    private
        Info : Unbounded_String:=To_Unbounded_String("");

        Brick_Matrix_State: Brick_Matrix;
        Pad1,Pad2 : Pad_Type;
        Ball: Ball_Type;
        Going : Boolean:=False;
        Game_Started : Ada.Calendar.Time;

    end Board_State;

    protected View_State is
        function Get
          return User_View_Type;
        procedure Angle_Change(Delta_H : in GLfloat ; Delta_V : in GLfloat);
        procedure Distance_Change(Delta_D : in GLdouble);
    private
        User_View: User_View_Type :=(Horizontal_Angle => 0.0,
                                     Vertical_Angle =>90.0,
                                     Distance => 2.5*GlDouble(Common_Data.Rozmiar_Planszy));
    end View_State;

    protected Players_State is
        function Get1
          return Key_Preset;
        function Get2
          return Key_Preset;
        procedure Set1(Nowy : in Key_Preset);
        procedure Set2(Nowy : in Key_Preset);
        procedure Add1(ile : in Integer);
        procedure Add2(Ile : in Integer);
        function R1
          return Integer;
        function R2
          return Integer;
        procedure Reset_Players;
    private
        Player1_Keys : Key_Preset:=AD;
        Player2_Keys : Key_Preset:=JL;
        Player1_Points : Integer := Initial_Points;
        Player2_Points : Integer := Initial_Points;
    end Players_State;

end Game_State_Package;