--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Process_Graphics
-- Krtki opis:		Pakiet odpowiedzialny za wyswietlanie grafiki.
--					zawiera funkcje sluzace do rysowania i obslugi zdarzen
--					zawiera zadanie ktore wykonuje sie jako osobny proces
--					Ew obsuga polega gownie na modyfikacji stanw.
--------------------------------------------------------------------------------
with Interfaces.C; use Interfaces.C;

package Process_Graphics is


    procedure Display;
    procedure Reshape (W : in Integer; H : in Integer);
    procedure Menu (Value : in Integer);
    procedure MotionFunc(X : in Integer;Y : in Integer);
    procedure KeyboardFunc(Znak : in Interfaces.C.unsigned_char; X : in Integer;Y : in Integer);
    procedure KeyboardUpFunc(Znak : in Interfaces.C.unsigned_char; X : in Integer;Y : in Integer);
    procedure MouseFunc(Button : in Integer;State : in Integer; X : in Integer;Y : in Integer);
    procedure JoystickFunc(Button_Mask : in Interfaces.C.Unsigned;X,Y,Z : Integer);
    procedure MenuStateFunc(Status: in Integer);

    procedure Init;

    procedure Update_Joy;
    procedure Redraw;

    task Processing_Graphics is
        entry Start;
        entry Wait_For_Initialization;
    end;

    task Redrawing is
        entry Start;
    end;
end Process_Graphics;