--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Process_Input_Package
--------------------------------------------------------------------------------
with Ada.Calendar,Ada.Exceptions,Win32.GL,Game_State_Package,Common_Data,Runtime_Log;
use Ada.Exceptions,Win32.GL,Game_State_Package,Common_Data,Runtime_Log;
use type Ada.Calendar.Time;




package body Process_Input_Package is

    ----------------------
    -- Processing_Input --
    ----------------------


    task body Processing_Input is
        Next_One : Ada.Calendar.Time:=Ada.Calendar.Clock;
    begin
        accept Start;
		
        loop
            delay until Next_One;
            if Keyboard_State.Is_Key_Down(Control_Config(Players_State.Get1).Go_L) then
                Board_State.Pad1_Go(L);
            end if;
            if Keyboard_State.Is_Key_Down(Control_Config(Players_State.Get1).Go_R) then
                Board_State.Pad1_Go(R);
            end if;
            if Keyboard_State.Is_Key_Down(Control_Config(Players_State.Get2).Go_L) then
                Board_State.Pad2_Go(L);
            end if;
            if Keyboard_State.Is_Key_Down(Control_Config(Players_State.Get2).Go_R) then
                Board_State.Pad2_Go(R);
            end if;
            if Keyboard_State.Is_Key_Down('+') then
                View_State.Distance_Change(-0.2);
            end if;
            if Keyboard_State.Is_Key_Down('=') then
                View_State.Distance_Change(-0.2);
            end if;
            if Keyboard_State.Is_Key_Down('-') then
                View_State.Distance_Change(+0.2);
            end if;
            Next_One:=Ada.Calendar.Clock+Common_Data.Input_Clock;
        end loop;
    exception
        when Event: others =>
            Log.Error("Nastapil wyjatek w module synchronizacji uruchomienia, nazwa: "
                      &Exception_Name(Event)&" jego opis: "& Exception_Message(Event));

    end Processing_Input;



    protected body Keyboard_State is

        procedure Set_Key_Down(Znak: in Character) is
        begin
            Klawiatura(Znak):=True;
        end;

        procedure Set_Key_Up(Znak: in Character) is
        begin
            Klawiatura(Znak):=False;
        end;

        function Is_Key_Down(Znak: in Character)
                           return Boolean is
        begin
            return Klawiatura(Znak);
        end;

    end Keyboard_State;


end Process_Input_Package;
