--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Process_Physics_Package
--------------------------------------------------------------------------------
with Win32.GL,Ada.Numerics.Elementary_Functions,Ada.Exceptions,Game_State_Package,Ada.Calendar,Common_Data,Runtime_Log;
use Win32.GL,Ada.Exceptions,Game_State_Package,Ada.Calendar,Common_Data,Runtime_Log;

package body Process_Physics_Package is

    function Mantisa (Num : in Glfloat)
                      return GLfloat is
    begin
        return Num-Glfloat'Floor(Num);
    end;

    function Check_Rad(Ball_x,Ball_y,corner_x,corner_y : in GLfloat)
                       return Boolean is
        Wekt_X : constant Glfloat:=(Ball_X-Corner_X);
        wekt_Y : constant Glfloat:=(Ball_Y-Corner_Y);
    begin
        if Wekt_X**2+Wekt_Y**2<0.25 then
            return True;
        else
            return False;
        end if;
    end;
    function Sqrt(X : in Glfloat)
                  return GlFloat is
    begin
        return Glfloat(Ada.Numerics.Elementary_Functions.SQRT(Float(X)));
    end;

    procedure UPSpeed(Vel :  in out GlFloat) is
        sgn : constant glfloat:=Vel/abs(Vel);
    begin
        Vel:=abs(Vel);
        Vel:=Vel+ 0.05*(sqrt(Ball_Velocity_Limit)-sqrt(Vel))**2;
        Vel:=Vel*sgn;
    end;


    procedure Destroy_Brick(Where_X,Where_Y :  in Integer; Ball : Ball_Type) is
        Simple_Brick : Brick:=Board_State.Get_Brick_Matrix_State(Where_Y,Where_X);
    begin
        if Simple_Brick.Destroyable then
            Log.Info("Zniszczono kostke: ["&Where_X'img&","&Where_Y'img&"], warta " & Simple_Brick.How_Many_Points'img & " punkow");
            if Ball.Owner=Player1 then
                Players_State.Add1(Simple_Brick.How_Many_Points);
            elsif Ball.Owner=Player2 then
                Players_State.Add2(Simple_Brick.How_Many_Points);
            end if;
            Simple_Brick.Exists:=False;
            Board_State.Set_Brick(where_X => Where_X,
                                  where_Y => where_Y,
                                  What    =>Simple_Brick );
        end if;
    exception
        when Event: others =>
            Log.Error("Nastapil wyjatek w module fizyki - niesczenie kostki- Destroy_Brick, nazwa: "
                      &Exception_Name(Event)&" jego opis: "& Exception_Message(Event));
    end;


    task body Process_Physics is
        next_One : Ada.Calendar.Time;
    begin
        accept Start;
        Board_State.Reset;
        accept Wait_For_Initialization;
        loop
            Next_One:=Ada.Calendar.Clock+Common_Data.Physics_Clock;
            if Board_State.Enabled then
                Wykrywanie_Klockow:
                declare
                    Current_Ball : constant Ball_Type :=Board_State.Get_Ball;

                    Ball_In_Brick_X : constant Integer:=Integer(glFloat'Floor(Current_Ball.Pos.X))+1;
                    Ball_In_Brick_Y : constant Integer:=Integer(glFloat'Floor(Current_Ball.Pos.Y))+1;

                    Reaction : Dir_Change:=(others=>False);
                    Simple_Bounce : Boolean:=False;
                begin

                    --Put_Line("Srodek kulki w klocku: ["&Ball_In_Brick_X'img&";"&Ball_In_Brick_Y'img&"]");
                    if Current_Ball.Velocity.X > 0.0 and then Board_State.Brick_Exists(Ball_In_Brick_X+1,Ball_In_Brick_Y) then
                        --Put_Line("porusza sie w prawo i istnieje klocek na sasiednim polu po prawej");
                        if Mantisa(Current_Ball.Pos.X)>0.5 then
                            Simple_Bounce:=True;
                            Reaction(L):=True;
                            Destroy_Brick(Ball_In_Brick_X+1,Ball_In_Brick_Y,Current_Ball);
                        end if;
                    elsif Current_Ball.Velocity.X <= 0.0 and then Board_State.Brick_Exists(Ball_In_Brick_X-1,Ball_In_Brick_Y) then
                        --Put_Line("porusza sie w lewo i istnieje klocek po lewej");
                        if Mantisa(Current_Ball.Pos.X)<0.5 then
                            Simple_Bounce:=True;
                            Reaction(R):=True;
                            Destroy_Brick(Ball_In_Brick_X-1,Ball_In_Brick_Y,Current_Ball);
                        end if;
                    end if;

                    if Current_Ball.Velocity.Y > 0.0 and then Board_State.Brick_Exists(Ball_In_Brick_X,Ball_In_Brick_Y+1) then
                        --Put_Line("porusza sie w gore i istnieje klocek na sasiednim polu u gory");
                        if Mantisa(Current_Ball.Pos.Y)>0.5 then
                            Simple_Bounce:=True;
                            Reaction(D):=True;
                            Destroy_Brick(Ball_In_Brick_X,Ball_In_Brick_Y+1,Current_Ball);
                        end if;
                    elsif Current_Ball.Velocity.Y <= 0.0 and then Board_State.Brick_Exists(Ball_In_Brick_X,Ball_In_Brick_Y-1) then
                        --Put_Line("porusza sie w dol i istnieje klocek pod");
                        if Mantisa(Current_Ball.Pos.Y)<0.5 then
                            Simple_Bounce:=True;
                            Reaction(U):=True;
                            Destroy_Brick(Ball_In_Brick_X,Ball_In_Brick_Y-1,Current_Ball);
                        end if;
                    end if;


                    if not Simple_Bounce then
                        --Put_Line("TRZEBA sprawdzic kolizje naroznikow");

                        if Current_Ball.Velocity.X > 0.0 and then Current_Ball.Velocity.Y > 0.0
                          and then Board_State.Brick_Exists(Ball_In_Brick_X+1,Ball_In_Brick_Y+1)
                          and then Check_Rad(Mantisa(Current_Ball.Pos.X),Mantisa(Current_Ball.Pos.Y),1.0,1.0) then
                            --Put_Line("odbijam!");
                            Reaction(LD):=True;
                            Destroy_Brick(Ball_In_Brick_X+1,Ball_In_Brick_Y+1,Current_Ball);
                        elsif Current_Ball.Velocity.X <= 0.0 and then Current_Ball.Velocity.Y > 0.0
                          and then Board_State.Brick_Exists(Ball_In_Brick_X-1,Ball_In_Brick_Y+1)
                          and then Check_Rad(Mantisa(Current_Ball.Pos.X),Mantisa(Current_Ball.Pos.Y),0.0,1.0) then
                            Reaction(RD):=True;
                            Destroy_Brick(Ball_In_Brick_X-1,Ball_In_Brick_Y+1,Current_Ball);
                        elsif Current_Ball.Velocity.X > 0.0 and then Current_Ball.Velocity.Y <= 0.0
                          and then Board_State.Brick_Exists(Ball_In_Brick_X+1,Ball_In_Brick_Y-1)
                          and then Check_Rad(Mantisa(Current_Ball.Pos.X),Mantisa(Current_Ball.Pos.Y),1.0,0.0) then
                            Reaction(LU):=True;
                            Destroy_Brick(Ball_In_Brick_X+1,Ball_In_Brick_Y-1,Current_Ball);
                        elsif Current_Ball.Velocity.X <= 0.0 and then Current_Ball.Velocity.Y <= 0.0
                          and then Board_State.Brick_Exists(Ball_In_Brick_X-1,Ball_In_Brick_Y-1)
                          and then Check_Rad(Mantisa(Current_Ball.Pos.X),Mantisa(Current_Ball.Pos.Y),0.0,0.0) then
                            Reaction(RU):=True;
                            Destroy_Brick(Ball_In_Brick_X-1,Ball_In_Brick_Y-1,Current_Ball);
                        end if;
                    end if;
                    Board_State.Ball_Bounce(Reaction);
                exception
                    when Event: others =>
                        Log.Error("Nastapil wyjatek w module fizyki - niszczenie/odbicia kostek, nazwa: "
                                  &Exception_Name(Event)&" jego opis: "& Exception_Message(Event));
                end Wykrywanie_Klockow;
			
                Wykrywanie_Padow:
                declare
                    Cur_Pad: Pad_Type;
                    Cur_Ball :  Ball_Type:=Board_State.Get_Ball;
                begin
                    if Cur_Ball.Pos.Y < 0.5 or else Cur_Ball.Pos.Y > Glfloat(Rozmiar_Planszy)-0.5 then
                        if Cur_Ball.Pos.Y < 0.5 then
                            Cur_Pad:=Board_State.Get_Pad1;
                            --Put_Line("Wykrywam pad nr 1");
                            if Cur_Ball.Pos.X > Cur_Pad.Position.X - Cur_Pad.Width/2.0
                              and then Cur_Ball.Pos.X < Cur_Pad.Position.X + Cur_Pad.Width/2.0 then
                                Cur_Ball.Velocity.Y:=abs(Cur_Ball.Velocity.Y);
                                upspeed(Cur_Ball.Velocity.Y);
                                Cur_Ball.Velocity.X:=Cur_Ball.Velocity.X+(Pad_roundness_level*(Cur_Ball.Pos.X-Cur_Pad.Position.X)/Cur_Pad.Width);
                                Cur_Ball.Owner:=Player1;
                                Cur_Ball.Pos.Y:=0.5;
                                Board_State.Ball_Change(Cur_Ball);
                            end if;
                        else
                            Cur_Pad:=Board_State.Get_Pad2;
                            --Put_Line("Wykrywam pad nr 2");
                            if Cur_Ball.Pos.X > Cur_Pad.Position.X - Cur_Pad.Width/2.0
                              and then Cur_Ball.Pos.X < Cur_Pad.Position.X + Cur_Pad.Width/2.0 then
                                Cur_Ball.Velocity.Y:=-abs(Cur_Ball.Velocity.Y);
                                upspeed(Cur_Ball.Velocity.Y);
                                Cur_Ball.Velocity.X:=Cur_Ball.Velocity.X+(Pad_roundness_level*(Cur_Ball.Pos.X-Cur_Pad.Position.X)/Cur_Pad.Width);
                                Cur_Ball.Owner:=Player2;
                                Cur_Ball.Pos.Y:=Glfloat(Rozmiar_Planszy)-0.5;
                                Board_State.Ball_Change(Cur_Ball);
                            end if;
                        end if;
                    end if;
                exception
                    when Event: others =>
                        Log.Error("Nastapil wyjatek w module fizyki - wykrywanie padow - odbic, nazwa: "
                                  &Exception_Name(Event)&" jego opis: "& Exception_Message(Event));

                end Wykrywanie_Padow;
                Wykrywanie_Przegranej:
                declare
                    Current_Ball : constant Ball_Type :=Board_State.Get_Ball;
                begin
                    if Current_Ball.Pos.Y <-1.5 then
                        Players_State.Add1(Ball_Penalty);
                        if Players_State.R1<0 then
                            Board_State.Stop;
                            Board_State.Set_Info("Wygra Gracz zielony !");
                        else
                            Board_State.Set_Info("Gracz czerwony traci: " & Ball_Penalty'Img & "punktow");
                            Log.Info("Gracz czerwony upuscil kulke, straci wiec: " &Ball_Penalty'img& " punktow");
                            delay 2.0;
                            Board_State.Set_Info("");
                            Board_State.Reset_Ball;
                            Log.Info("Kulka zostala zresetowana");
                        end if;
                    elsif Current_Ball.Pos.Y > GLfloat(Rozmiar_Planszy)+1.5 then
                        Players_State.Add2(Ball_Penalty);
                        if Players_State.R2<0 then
                            Board_State.Stop;
                            Board_State.Set_Info("Wygra Gracz czerwony !");
                        else
                            Board_State.Set_Info("Gracz zielony traci: " & Ball_Penalty'Img & "punktw");
                            Log.Info("Gracz zielony upuscil kulke, straci wiec: " &Ball_Penalty'img& " punktow");
                            delay 2.0;
                            Board_State.Set_Info("");
                            Board_State.Reset_Ball;
                            Log.Info("Kulka zostala zresetowana");
                        end if;
                    end if;
                exception
                    when Event: others =>
                        Log.Error("Nastapil wyjatek w module fizyki - wykrywanie przegranej, nazwa: "
                                  &Exception_Name(Event)&" jego opis: "& Exception_Message(Event));
                end Wykrywanie_Przegranej;
                Board_State.Ball_Step;
            end if;
            delay until Next_One;
        end loop;
    exception
        when Event: others =>
            Log.Error("Nastapil wyjatek w module fizyki, nazwa: "
                      &Exception_Name(Event)&" jego opis: "& Exception_Message(Event));
    end Process_Physics;

end Process_Physics_Package;
