--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Common_Data
-- Krtki opis:		Pakiet zawierajacy powszechnie uzywane typy
--					oraz zmienne konfiguracyjne i wspoldzielone globalnie
--------------------------------------------------------------------------------

with Win32.Gl,Ada.Calendar;
use  Win32.Gl,Ada.Calendar;

package Common_Data is
    Rozmiar_Planszy : constant Natural:=20;
    Pad_Mps:constant Glfloat := 1.0;

    Game_Version : String := "0.2";
    PC_fail_rate : Float:=0.4;
    Physics_Clock : constant Duration:=0.001;
    Input_Clock : constant Duration:=0.01;
    PC_Sampling_Clock : constant Duration:=0.01;
    Frame_Rate : Constant Positive :=35;
    Ball_Velocity_Limit : Glfloat := 45.0;
    Pad_Roundness_Level : Glfloat := 10.0;
    Ball_Penalty:Integer :=-500;
    Initial_Points : constant Integer:=600;
    Program_Started : Time:=Ada.Calendar.Clock;
    Board_Pattern: String:="board (0).txt";

    Window_Pos_X : Integer:=50;
    Window_Pos_Y : Integer:=50;
    Window_Width : Integer:=600;
    Window_Height : Integer:=600;
    Joy_Right : constant Character := Character'Val(230);
    Joy_Left : constant Character := Character'Val(229);
    PC_Right : constant Character := Character'Val(232);
    PC_Left : constant Character := Character'Val(231);
    Pad_Step : constant Glfloat:=glfloat(Rozmiar_Planszy)*Pad_mps*glfloat(Input_Clock);
    type Ball_Owner is (Player1,Player2,None);
    subtype real_player is Ball_Owner range Player1..Player2;
    type Key_Preset is (AD,JL,Pad,Computer);
    type Key_Set_Type is
        record
            Go_L,Go_R : Character;
        end record;
    type Control_Config_type is array (Key_Preset) of Key_Set_Type;
    Control_Config :constant Control_Config_Type :=
      (AD=>(Go_L=>'a',Go_R=>'d'),JL=>(Go_L=>'j',Go_R=>'l'),Pad=>(Go_L=>Joy_Left,Go_R=>Joy_Right),Computer=>(Go_L=>PC_Left,Go_R=>PC_Right));

    subtype Brick_Points is Integer range 0..30;
    subtype Probability is Float range 0.0..1.0;
    type Color_Part is (R,G,B);
    type Color_Type is array(Color_Part) of Win32.Gl.GLFloat;
    type Direction is (L,R,U,D,RU,RD,LU,LD);
    type Dir_Change is array (Direction) of Boolean;
    type Vector is
        record
            X : Glfloat;
            Y : Glfloat;
        end record;
    Initial_Ball_Pos : Vector:=(others=>0.5*Glfloat(Rozmiar_Planszy));
    Initial_Ball_Vel : Vector:=(X=>0.0,Y=>12.0);

    type Ball_Type is
        record
            Color : Color_Type;
            Pos : Vector;
            Velocity : Vector;
            Owner : Ball_Owner;
        end record;
    type Pad_Type is
        record
            Color : 					Color_Type;
            Width : 					GLfloat;
            Position: Vector;
        end record;
    type Brick is
        record
            Exists:					Boolean;
            How_Many_Points : 			Brick_Points;
            Destroyable : 				Boolean;
            --Probability_Of_Explosion : Probability;
            --Probability_Of_Bonus :		Probability;
            Color : 					Color_Type;
        end record;

    function Lenght(Wek : in Vector)
                    return glfloat;
end Common_Data;
