with Process_Graphics;
with Process_Input_Package;
with Process_Physics_Package;
with Runtime_Log; use Runtime_Log;
with Ada.Exceptions; use Ada.Exceptions;
with Common_Data;use Common_Data;

procedure Multiplayer_Arkanoid is
begin
    Log.Info("Procedura glowna zostala uruchomiona");
    Log.Info("Wypisywanie stanu biezacych ustawien");
    Log.Info("Rozmiar Planszy: " & Rozmiar_Planszy'img);
    Log.Info("Symulacja fizyki - interval: " & Integer(Physics_Clock*1000.0)'img &" ms");
    Log.Info("Oczekiwany FrameRate: " & Frame_Rate'img & "fps");
    Log.Info("Keyboard/Pad input sampling: " & Integer((1.0/float(Input_Clock)))'img &" Hz");
    Log.Info("Inicjalizuje Silnik graficzny");


    Process_Graphics.Processing_Graphics.Start;
    Process_Graphics.Processing_Graphics.Wait_For_Initialization;
    Log.Info("Zakonczono inicjalizowanie okna, jest gotowe");

    Log.Info("Uruchamiam symulacje fizyki");
    process_physics_package.Process_Physics.Start;
    Process_Physics_Package.Process_Physics.Wait_For_Initialization;
    Log.Info("Symulacja Fizyki juz dziaa");
    Log.Info("Wlaczanie Gracza zielonego");
    Process_Graphics.Menu(424);
    Process_Input_Package.Processing_Input.Start;
    Log.Info("Zadania uruchomione");

exception
    when Event: others =>
        Log.Error("Nastapil wyjatek w module synchronizacji uruchomienia, nazwa: "
                  &Exception_Name(Event)&" jego opis: "& Exception_Message(Event));
end Multiplayer_Arkanoid;
