<?php

/**
 * Seat filter form base class.
 *
 * @package    balsit
 * @subpackage filter
 * @author     Krzysiek Wesołowski
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseSeatFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'board_id'        => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Board'), 'add_empty' => true)),
      'seller_id'       => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUser'), 'add_empty' => true)),
      'guest_id'        => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Guest'), 'add_empty' => true)),
      'partner_seat_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Seat'), 'add_empty' => true)),
      'sold_time'       => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate())),
      'price'           => new sfWidgetFormFilterInput(),
      'comment'         => new sfWidgetFormFilterInput(),
      'sold'            => new sfWidgetFormChoice(array('choices' => array('' => 'yes or no', 1 => 'yes', 0 => 'no'))),
    ));

    $this->setValidators(array(
      'board_id'        => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Board'), 'column' => 'id')),
      'seller_id'       => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('sfGuardUser'), 'column' => 'id')),
      'guest_id'        => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Guest'), 'column' => 'id')),
      'partner_seat_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Seat'), 'column' => 'id')),
      'sold_time'       => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'price'           => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'comment'         => new sfValidatorPass(array('required' => false)),
      'sold'            => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
    ));

    $this->widgetSchema->setNameFormat('seat_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Seat';
  }

  public function getFields()
  {
    return array(
      'id'              => 'Number',
      'board_id'        => 'ForeignKey',
      'seller_id'       => 'ForeignKey',
      'guest_id'        => 'ForeignKey',
      'partner_seat_id' => 'ForeignKey',
      'sold_time'       => 'Date',
      'price'           => 'Number',
      'comment'         => 'Text',
      'sold'            => 'Boolean',
    );
  }
}
