<?php

/**
 * Guest form base class.
 *
 * @method Guest getObject() Returns the current form's model object
 *
 * @package    balsit
 * @subpackage form
 * @author     Krzysiek Wesołowski
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseGuestForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'         => new sfWidgetFormInputHidden(),
      'gender_id'  => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Gender'), 'add_empty' => false)),
      'title'      => new sfWidgetFormInputText(),
      'name'       => new sfWidgetFormInputText(),
      'surname'    => new sfWidgetFormInputText(),
      'university' => new sfWidgetFormInputText(),
      'index_nr'   => new sfWidgetFormInputText(),
      'telephone'  => new sfWidgetFormInputText(),
      'email'      => new sfWidgetFormInputText(),
      'created_at' => new sfWidgetFormDateTime(),
      'updated_at' => new sfWidgetFormDateTime(),
    ));

    $this->setValidators(array(
      'id'         => new sfValidatorDoctrineChoice(array('model' => $this->getModelName(), 'column' => 'id', 'required' => false)),
      'gender_id'  => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Gender'))),
      'title'      => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'name'       => new sfValidatorString(array('max_length' => 255)),
      'surname'    => new sfValidatorString(array('max_length' => 255)),
      'university' => new sfValidatorString(array('max_length' => 255)),
      'index_nr'   => new sfValidatorInteger(array('required' => false)),
      'telephone'  => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'email'      => new sfValidatorString(array('max_length' => 255)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('guest[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Guest';
  }

}
