@echo off
echo ' GLUT Installation V1.2, 15 July 2003
echo '     (c) COL Gene Ressler 2002, 2003
echo '
if "%1"=="" goto nopathgiven

set gnatdir=%1

:trycopy

echo '
echo ' Attempting to install GLUT.
echo '
echo '
echo ' Looking for GNAT at %gnatdir%...
echo '
if not exist %gnatdir%\bin goto nognat
if not exist %gnatdir%\lib goto nognat
if not exist %gnatdir%\Bindings\Win32Ada goto nowin32

echo '
echo ' Copying GLUT binding...
echo '
copy binding\libglut32.a %gnatdir%\lib > nul
if errorlevel 1 goto copy_failed
copy binding\glut32.dll %gnatdir%\bin > nul
if errorlevel 1 goto copy_failed
copy binding\win32-glut.ads %gnatdir%\Bindings\Win32Ada > nul
if errorlevel 1 goto copy_failed
del /f/q %gnatdir%\Bindings\Win32Ada\glut.ads > nul 2>&1
copy binding\win32-glut.adb %gnatdir%\Bindings\Win32Ada > nul
if errorlevel 1 goto copy_failed
del /f/q %gnatdir%\Bindings\Win32Ada\glut.adb > nul 2>&1
echo '
echo ' Copying updated GL binding...
echo '
copy GlPatch\win32-gl.ads %gnatdir%\Bindings\Win32Ada > nul
if errorlevel 1 goto copy_failed
echo '
echo ' Attempting to recompile the binding...
echo '
attrib -R %gnatdir%\Bindings\Win32Ada\win32-gl.ali
if errorlevel 1 goto glumake_failed
attrib -R %gnatdir%\Bindings\Win32Ada\win32-glu.ali
if errorlevel 1 goto glumake_failed
attrib -R %gnatdir%\Bindings\Win32Ada\win32-glut.ali > nul 2>&1
set save_cd=%cd%
cd /d %gnatdir%\Bindings\Win32Ada 
%gnatdir%\bin\gnatmake -O win32-gl
%gnatdir%\bin\gnatmake -O win32-glu 
%gnatdir%\bin\gnatmake -O win32-glut 
cd /d %save_cd% 
if errorlevel 1 goto glumake_failed
attrib +R %gnatdir%\Bindings\Win32Ada\win32-gl.ali
if errorlevel 1 goto glumake_failed
attrib +R %gnatdir%\Bindings\Win32Ada\win32-glu.ali
if errorlevel 1 goto glumake_failed
attrib +R %gnatdir%\Bindings\Win32Ada\win32-glut.ali
if errorlevel 1 goto glumake_failed
echo '
echo ' GLUT installation was successful.
echo '

goto done

:nopathgiven
set gnatdir=C:\gnat
echo ' I am assuming GNAT is located at
echo '
echo '   %gnatdir%
echo '
echo ' because you didn't give me a path.
echo '
goto trycopy

:copy_failed
echo ' Could not copy a required file.  Fatal error. Bye!
goto done

:glumake_failed
echo ' Could not rebuild the GLU library. It's likely you'll
echo ' get binder errors when you try to compile GLUT programs.
echo ' Explain this to your instructor.
goto done

:nognat
echo ' Could not find Gnat at %gnatdir%
echo '
echo ' You must try again by starting this script with:
echo '
echo '   install x:\mygnatdir (enter)
echo '
echo ' where x:\mygnatdir is the directory where you have already installed GNAT.
echo '
goto done

:nowin32
echo ' Could not find GnatWin, the Gnat binding to Win32 API.  Please install the 
echo ' binding and try again.
echo '

:done
